<html>
<head>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
</head>
<body>
    <div id="app" class="p-3">
        <h1 class="mb-3">Laravelファイルをアップロードするサンプル</h1>
        <p class="bg-light p-3">顧客データをプロフィール写真を一緒に保存する場面を想定しています。</p>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>名前</label>
                    <input type="text" class="form-control" v-model="params.name">
                </div>
                <div class="form-group">
                    <label>メールアドレス</label>
                    <input type="text" class="form-control" v-model="params.email">
                </div>
                <div class="form-group">
                    <label>写真（複数選べます）</label>
                    <!-- ファイル選択部分 -->
                    <input
                        ref="photo"
                        type="file"
                        class="form-control"
                        accept="image/gif,image/jpeg,image/png"
                        @change="onFileChange"
                        multiple>
                </div>
                <div class="text-right">
                    <button type="button" class="btn btn-primary" @click="onSubmit">送信する</button>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                params: {
                    name: '',
                    email: ''
                },
                photos: []
            },
            methods: {
                onFileChange(e) {

                    this.photos = e.target.files; // ファイルを変数に格納

                },
                onSubmit() {

                    // 送信データを用意する
                    let formData = new FormData();
                    formData.append('name', this.params.name);
                    formData.append('email', this.params.email);

                    for(let photo of this.photos) {

                        formData.append('photos[]', photo);

                    }

                    axios.post('/ajax/customer', formData)
                        .then(response => {

                            if(response.data.result) {

                                alert('アップロード成功！');

                                // 入力データを初期化
                                this.params = {
                                    name: '',
                                    email: ''
                                };
                                this.$refs['photo'].value = '';

                            }

                        })
                        .catch(error => {

                            // ここでエラー処理
                            console.log(error);

                        });

                }
            }
        });

    </script>
</body>
</html>
